/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.snmp;

import ibm.nways.jdm.common.Counter;
import ibm.nways.jdm.common.Counter64;
import ibm.nways.jdm.common.EndOfMibView;
import ibm.nways.jdm.common.Gauge;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.NoSuchInstance;
import ibm.nways.jdm.common.NoSuchObject;
import ibm.nways.jdm.common.Null;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.common.Opaque;
import ibm.nways.jdm.common.TimeTicks;
import ibm.nways.jdm.snmp.SnmpBERlength;
import java.io.Serializable;

public class SnmpVarBind
implements Serializable {
    OID oid;
    Serializable variable;
    int oidBERlength;
    int varBERlength;
    private static Null nullInstance = new Null();

    public SnmpVarBind() {
        this.oid = null;
        this.variable = nullInstance;
    }

    public SnmpVarBind(OID oID) {
        this.oid = oID;
        this.variable = nullInstance;
    }

    public SnmpVarBind(SnmpVarBind snmpVarBind) {
        this.oid = new OID(snmpVarBind.oid);
        this.variable = snmpVarBind.variable;
    }

    public SnmpVarBind(OID oID, Serializable serializable) {
        this.oid = oID;
        this.variable = serializable;
        if (this.variable instanceof String) {
            this.variable = new OctetString((String)((Object)serializable), true);
        }
    }

    public String toString() {
        if (this.variable instanceof OctetString && ((OctetString)this.variable).isDisplayString()) {
            return "\n\t" + this.oid.toString() + ":" + ((OctetString)this.variable).toDisplayString();
        }
        return "\n\t" + this.oid.toString() + ":" + this.variable.toString();
    }

    public OID get_oid() {
        return this.oid;
    }

    public OID getOID() {
        return this.oid;
    }

    public Serializable get_value() {
        return this.variable;
    }

    public Serializable getVar() {
        return this.variable;
    }

    public void set_oid(OID oID) {
        this.oid = oID;
        this.oidBERlength = 0;
    }

    public void set_value(Serializable serializable) {
        this.variable = serializable;
        this.varBERlength = 0;
    }

    public void set_null() {
    }

    public int get_syntax() {
        int n = 5;
        if (this.variable instanceof Null) {
            n = 5;
        } else if (this.variable instanceof Counter) {
            n = 65;
        } else if (this.variable instanceof Integer) {
            n = 2;
        } else if (this.variable instanceof OctetString) {
            n = 4;
        } else if (this.variable instanceof OID) {
            n = 6;
        } else if (this.variable instanceof IPAddress) {
            n = 64;
        } else if (this.variable instanceof Gauge) {
            n = 66;
        } else if (this.variable instanceof TimeTicks) {
            n = 67;
        } else if (this.variable instanceof Counter64) {
            n = 70;
        } else if (this.variable instanceof NoSuchObject) {
            n = -128;
        } else if (this.variable instanceof NoSuchInstance) {
            n = -127;
        } else if (this.variable instanceof EndOfMibView) {
            n = -126;
        } else if (this.variable instanceof Opaque) {
            n = 68;
        }
        return n;
    }

    public void set_exception_status(int n) {
        switch (n) {
            case -128: {
                this.variable = new NoSuchObject();
                return;
            }
            case -127: {
                this.variable = new NoSuchInstance();
                return;
            }
            case -126: {
                this.variable = new EndOfMibView();
                return;
            }
        }
        this.variable = nullInstance;
    }

    public String get_printable_value() {
        return this.variable.toString();
    }

    public String get_printable_oid() {
        return this.oid.toString();
    }

    boolean valid() {
        return true;
    }

    public int getBERlength() {
        if (this.oidBERlength == 0) {
            this.getOIDlength();
        }
        int n = this.oidBERlength + 1 + SnmpBERlength.size((int)this.oidBERlength);
        if (this.varBERlength == 0) {
            this.getVarLength();
        }
        return n += this.varBERlength + 1 + SnmpBERlength.size((int)this.varBERlength);
    }

    public int getOIDlength() {
        if (this.oidBERlength == 0) {
            this.oidBERlength = this.oid.getBERlength();
        }
        return this.oidBERlength;
    }

    public int getVarLength() {
        if (this.varBERlength == 0) {
            if (this.variable instanceof Integer) {
                int n = (Integer)this.variable;
                this.varBERlength = n < 128 && n >= -128 ? 1 : (n < 32768 && n >= Short.MIN_VALUE ? 2 : (n < 0x800000 && n >= -8388608 ? 3 : 4));
            } else if (this.variable instanceof OctetString) {
                this.varBERlength = ((OctetString)this.variable).value.length;
            } else if (this.variable instanceof Gauge) {
                long l = ((Gauge)this.variable).value;
                this.varBERlength = SnmpVarBind.getLongLength(l);
            } else if (this.variable instanceof TimeTicks) {
                long l = ((TimeTicks)this.variable).value;
                this.varBERlength = SnmpVarBind.getLongLength(l);
            } else if (this.variable instanceof IPAddress) {
                this.varBERlength = 4;
            } else if (this.variable instanceof Null) {
                this.varBERlength = 0;
            } else if (this.variable instanceof Counter) {
                long l = ((Counter)this.variable).value;
                this.varBERlength = SnmpVarBind.getLongLength(l);
            } else if (this.variable instanceof Counter64) {
                long l = ((Counter64)this.variable).value;
                this.varBERlength = SnmpVarBind.getLongLength(l);
            } else if (this.variable instanceof OID) {
                this.varBERlength = ((OID)this.variable).getBERlength();
            } else if (this.variable instanceof NoSuchObject) {
                this.varBERlength = 0;
            } else if (this.variable instanceof NoSuchInstance) {
                this.varBERlength = 0;
            } else if (this.variable instanceof EndOfMibView) {
                this.varBERlength = 0;
            }
        }
        return this.varBERlength;
    }

    protected static int getLongLength(long l) {
        if (l < 0L) {
            return 9;
        }
        if (l < 128L) {
            return 1;
        }
        if (l < 32768L) {
            return 2;
        }
        if (l < 0x800000L) {
            return 3;
        }
        if (l < 0x80000000L) {
            return 4;
        }
        if (l < 0x8000000000L) {
            return 5;
        }
        if (l < 0x800000000000L) {
            return 6;
        }
        if (l < 0x80000000000000L) {
            return 7;
        }
        if (l <= 0x7F00000000000000L) {
            return 8;
        }
        return 9;
    }
}

